<?php #CodeGenerator Δ 050b998b409c1301fee958418b8a9504 Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * JSON:API Schema Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-07-22 09:37:21
 * @package     bplan-base/globals
 * @subpackage  Schemas
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\JsonApi\Data\Tenants;


use BplanBase\Globals\Models\Tenant;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use LaravelJsonApi\Eloquent\Contracts\Paginator;
use LaravelJsonApi\Eloquent\Fields\Boolean;
use LaravelJsonApi\Eloquent\Fields\DateTime;
use LaravelJsonApi\Eloquent\Fields\ID;
use LaravelJsonApi\Eloquent\Fields\Relations\BelongsTo;
use LaravelJsonApi\Eloquent\Fields\Relations\HasMany;
use LaravelJsonApi\Eloquent\Fields\Relations\HasOne;
use LaravelJsonApi\Eloquent\Fields\Str;
use LaravelJsonApi\Eloquent\Filters\WhereIdIn;
use LaravelJsonApi\Eloquent\Pagination\PagePagination;
use LaravelJsonApi\Eloquent\Schema;


/**
 * JSON:API Schema Class
 *
 * @version     2.2.0 / 2025-07-22
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantSchema extends Schema
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The maximum include path depth.
     *
     * @var int
     */
    protected int $maxDepth = 2;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The model the schema corresponds to.
     *
     * @var         string
     */
    public static string $model = Tenant::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Get the resource fields.
     *
     * @return      array
     *
     * @version     1.3.0 / 2025-07-22
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function fields(): array
    {

        $timezone = config('app.timezone');

        return [
            ID::make(),

            Boolean::make('active')->sortable(),
            DateTime::make('createdAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),

            DateTime::make('deletedAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),

            DateTime::make('updatedAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),

            Str::make('uuid')->readOnly()->sortable(),

            Str::make('identifier')->sortable(),
            Boolean::make('internal'),
            /*
            **  Relations */
            HasMany::make('assigned-users')->type('users')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            HasMany::make('entity-types')->type('entity-types')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            HasMany::make('external-systems')->type('tenant-external-systems')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            HasMany::make('import-logs')->type('import-logs')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            HasMany::make('locales')->type('tenant-locales')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            BelongsTo::make('master-tenant')->type('tenants')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            HasMany::make('modules')->type('modules')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            HasMany::make('roles')->type('roles')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            HasMany::make('sub-tenants')->type('tenants')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            HasOne::make('tenant-record')->type('tenant-records')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            HasMany::make('users')->type('users')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),

        ];
    } // fields()


    /**
     * Get the resource filters.
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-07-22
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function filters(): array
    {
        return [
            WhereIdIn::make($this),
        ];
    } // filters()


    /**
     * Build an index query for this resource.
     *
     * @param       Request|null $Request
     *
     * @param       Builder $Query
     *
     * @return      Builder

     * @version     1.0.0 / 2025-07-22
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function indexQuery(?Request $Request, Builder $Query): Builder
    {
        return $Query->where(function (Builder $Query) {
            return $Query;
        });
    } // indexQuery()


    /**
     * Get the resource paginator.
     *
     * @return      null|Paginator
     *
     * @version     1.0.0 / 2025-07-22
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function pagination(): ?Paginator
    {
        return PagePagination::make();

    } // pagination()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantSchema extends Schema {}
