<?php
/**
 * DataGrid Wrapper for Livewire
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  DataGrid
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Components;


use BplanBase\Globals\DataGrid\DataGrid;
use Livewire\Component;


/**
 * DataGrid Wrapper for Livewire
 *
 * @version     1.0.0 / 2025-09-07
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DataGridWrapper extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Assoziatives Array für Spaltenüberschriften
     *
     * @var     DataGrid $grid
     */
    public DataGrid $grid;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       DataGrid $grid
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-09-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount(DataGrid $grid): void
    {
        $this->grid = $grid;

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-09-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('globals::livewire.data-grid.wrapper', [
            'grid' => $this->grid,
        ]);
    } // render()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class DataGridWrapper extends Component {}
