<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Global;


use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.1.0 / 2025-10-01
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class SortSelect extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var array
     */
    public array $columns = [];


    /**
     * @var null|string
     */
    public null|string $direction;


    /**
     * @var null|string
     */
    public null|string $selectedColumn = null;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $columns
     *
     * @param       null|string $selectedColumn
     *
     * @param       string $direction
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-09-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount(array $columns, null|string $selectedColumn = null, string $direction = 'asc'): void
    {
        $this->columns = $columns;
        $this->selectedColumn = $selectedColumn;
        $this->direction = $direction;

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-09-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('globals::livewire.global.sort-select');

    } // render()


    /**
     *
     * @param       string $column
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-09-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setColumn(string $column)
    {
        $this->selectedColumn = $column;

        $this->dispatch('sortingChanged', $this->selectedColumn, $this->direction);

    } // setColumn()


    /**
     *
     * @param       string $direction
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-09-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setDirection(string $direction)
    {
        $this->direction = $direction;

        $this->dispatch('sortingChanged', $this->selectedColumn, $this->direction);

    } // setDirection()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class SortSelect extends Component {}
