<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-05 20:20:17
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Users;


use BplanBase\Globals\Repositories\IndexCollectionRepository;
use BplanBase\Globals\Models\User;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     2.0.0 / 2025-08-01
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Index extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $search
     */
    public ?string $search = '';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-08-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getUsers()
    {
        $ExtendQuery = null;

        $this->search = trim($this->search);

        if (!empty($this->search)) {
            /*
            **  Query mit Filter-Parametern zusammenstellen. */
            $ExtendQuery = User::where(function ($Q) {
                $Q->where('email', 'like', '%'.$this->search.'%')
                    ->orWhere('name', 'like', '%'.$this->search.'%');
            });
        }
        return IndexCollectionRepository::getUsers(
            ExtendQuery: $ExtendQuery,
            paginate: ['pageName' => 'users-page'],
            withInternal: (bool) auth()->user()->internal
        );
    } // _getUsers()


    /**
     *
     * @version     1.1.0 / 2025-08-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('user-created'), On('user-edited'), On('user-deleted')]
    public function render()
    {
        return view('globals::livewire.users.index', [
            'users' => $this->_getUsers()
        ]);
    } // render()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Index extends Component {}
