<?php
/**
 * Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Repositories\Core;


use BplanBase\Globals\Models\Role;
use BplanBase\Globals\Repositories\RoleRepository as BaseRepository;
use BplanBase\Globals\Scopes\TenantScope;
use Illuminate\Database\Eloquent\Collection;


/**
 * Repository Class
 *
 * @version     1.0.0 / 2025-08-27
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RoleRepository extends BaseRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Liefert eine Collection mit den Roles zum Tenant
     *
     * @param       int|string $tenantId
     *
     * @return      Collection
     *
     * @version     1.0.0 / 2025-08-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getTenantRoles(int|string $tenantId, bool $ignoreCache = false): Collection
    {
        static $cache = [];

        $cacheKey = md5(json_encode(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = static::$_modelClass::where('tenant_id', '=', $tenantId)
            // ->withoutGlobalScope(TenantScope::class)
            ;
// $Query->dumpRawSql(); dump($Query->get()->toArray());
        return $cache[$cacheKey] = $Query->get();

    } // getTenantRoles()


} // class RoleRepository extends BaseRepository {}
