<?php
/**
 * Setup Logger Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Setup
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Setup;


/**
 * Setup Logger Class
 *
 * @version     1.0.0 / 2025-08-12
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Logger
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string STATUS_DONE
     */
    const FILE_NAME = 'setup.log';


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array|string $fileContents
     *
     * @return      int|false
     *
     * @version     1.0.0 / 2025-08-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function log(array|string $fileContents, string|null $context = null): int|false
    {
        if (is_array($fileContents)) {
            $fileContents = ' '.implode("\n".' ', $fileContents);
        }
        $fileContents = "\n".'>>> '.((string) $context)."\n".$fileContents;

        return file_put_contents(
            storage_path('logs/'.self::FILE_NAME),
            "\n".$fileContents,
            FILE_APPEND
        );
    } // log()


    /**
     *
     * @return      int|false
     *
     * @version     1.0.0 / 2025-08-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function reset(): int|false
    {
        return file_put_contents(
            storage_path('logs/'.self::FILE_NAME),
            '['.date('Y-m-d H:i:s').']'
        );
    } // reset()


} // class Logger {}
