<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  ViewComponents
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\View\Components\FormElements;


use Closure;


use Illuminate\Support\Collection;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;


/**
 * HTML-Input
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Placeholder extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_attributeStrings
     */
    protected $_attributeStrings = [];


    /**
     * @var     string $attributeString
     */
    public $attributeString;


    /**
     * @var     string $classAddition
     */
    public $classAddition = '';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Create a new component instance.
     *
     * @param       array $attributes
     *
     * @param       bool $disabled
     *
     * @param       null|string $label
     *
     * @param       int $width
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(array $attributes = [],
        public bool $disabled = false,
        public null|string $label = '',
        public int $width = 2
    ) {
//        $this->_init($name);
//        $this->_processAttributes($attributes);

    } // __construct()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareAttributeString()
    {
        ksort($this->_attributeStrings);

        $this->attributeString = ' '.implode(' ', $this->_attributeStrings);

    } // _prepareAttributeString()


    /**
     *
     * @param       array $attributes
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processAttributes(array $attributes): void
    {
        if (!empty($attributes)) {
            foreach ($attributes as $attribute => $value) {
                $attribute = strtolower($attribute);

                if ($attribute === 'class' || $attribute === 'id' || $attribute === 'name' || $attribute === 'type' || $attribute === 'wire') {
                    continue;
                }
                $this->_attributeStrings[$attribute] = $attribute.'="'.$value.'"';
            }
            if (isset($attributes['class'])) {
                $this->classAddition .= ' '.$attributes['class'];
            }
        }
        if (isset($attributes['id'])) {
            $this->_attributeStrings['id'] = 'id="'.$attributes['id'].'"';
        } else {
            $this->_attributeStrings['id'] = 'id="'.$this->id.'"';
        }
        if (isset($this->disabled) && $this->disabled === true) {
            $this->_attributeStrings['disabled'] = 'disabled="disabled"';
        }
    } // _processAttributes()


    /**
     * Get the view / contents that represent the component.
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render(): View|Closure|string
    {
        $this->_prepareAttributeString();

        return view('globals::components.form-elements.placeholder');

    } // render()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Placeholder extends BaseFormElement {}
