<?php
/**
 * Blade Component Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  BladeComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\View\Components\Global;


use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;


/**
 * Blade Component Class
 *
 * @version     1.0.0 / 2025-08-07
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class InputMultiLanguageJson extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    public ?array $labelsJson;

    public string $target;

    public ?string $windowTitle = null;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Create a new component instance.
     *
     * @param       array|null $labelsJson
     *
     * @param       string $target
     *
     * @param       string|null $windowTitle
     *
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function __construct(?array $labelsJson = [], string $target = 'create', ?string $windowTitle = null)
    {
        $this->labelsJson = $labelsJson;
        $this->target = $target;

        if(empty($windowTitle))
        {
            $this->windowTitle = trans('globals::global.caption.labels');
        }
    } // __construct()


    // /**
    //  * Create a new component instance.
    //  */
    // public function __construct(
    //     public ?array $labelsJson = [],
    //     public string $target = 'create',
    //     public ?string $windowTitle = null,
    // )
    // {
    //     if(empty($windowTitle))
    //     {
    //         $this->windowTitle = trans('globals::global.caption.labels');
    //     }
    // }


    /**
     * Get the view / contents that represent the component.
     *
     * @return      View|Closure|string
     *
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function render(): View|Closure|string
    {
        return view('globals::components.global.input-multi-language-json');

    } // render()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class InputMultiLanguageJson extends Component {}
