<?php
/**
 * View Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  ViewModels
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\ViewModels;


/**
 * View Model Class
 *
 * @version     1.0.0 / 2025-08-10
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
final class MenuItem
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       public readonly string $label,
     *
     * @param       public readonly ?string $url,
     *
     * @param       public readonly ?string $icon
     *
     * @param       public readonly ?string $identifier
     *
     * @param       public readonly ?array $children
     *
     * @param       public readonly int $order
     *
     * @param       public readonly bool $active
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-08-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(
        public readonly string $label,
        public readonly ?string $url = null,
        public readonly ?string $icon = null,
        public readonly ?string $identifier = null,
        /** @var MenuItem[]|null */
        public readonly ?array $children = null,
        public readonly int $order = 0,
        public readonly bool $active = false

    ) {}


    /**
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-08-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function hasChildren(): bool
    {
        return !empty($this->children);

    } // hasChildren()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // final class MenuItem {}
