# Globals

A package with global basic components such as locales, helper classes, enums, traits, etc.

## Installation

As the package is not in a public repository, the repository must be registered in the first installation step. To avoid having to register a separate repository for each private package, selected packages are made available via a central repository:

`composer config repositories.bplan-base/composer-packages composer https://satis.bplan.solutions`

The package can then be installed:

`composer require bplan-base/globals`

### Middlewares
The package includes a few middlewares for the api and web context. To use these middlewares in the project, changes to the “_bootstrap/app.php_” file are required.

```
return Application::configure(basePath: dirname(\_\_DIR\_\_))
    ->withRouting(
        ...
    ) ->withMiddleware(function (Middleware $middleware) {

        $middleware->api(append: **GlobalsServiceProvider::getApiMiddlewares()**);
        $middleware->web(append: **GlobalsServiceProvider::getWebMiddlewares()**);
        ...
    })->withExceptions(function (Exceptions $exceptions) {
	...

```
These changes make the global middleware “LogApiRequest” available for the api routes and “SetLocale” for the web routes. 

As the name suggests, “LogApiRequest” ensures that API requests are written to a log file. The configuration option `API_LOG_LEVEL` can be used to control how extensive the logged data should be.
Possible settings are:
```
	1 = minimum log data,
	2 = extended log data,
	3 = complete log data.
```
Regardless of the log level set, complete data is always saved in the event of an error.

“SetLocale” sets the language of the application. The `“GET /locale/{locale}”` route is available for changing the language.

The package also provides middleware with the alias “access-level.or.roles”, which checks the access level and/or one or more roles of the logged-in user.
Usage:

```
Route::middleware(\[
    'auth:sanctum',
    config('jetstream.auth\_session'),
    'verified',
    **'access-level.or.roles:SystemManager,Host,Logistics'**

\]) ...
```
In the previous example, “SystemManager” stands for an access level. One or more role names can be specified as further optional parameters. If only roles and no access level are to be checked, then “null” must be entered for the access level.


## Configuration

* API\_LOG\_LEVEL - Sets the level for API logging. Log files are saved in “_storage/logs/api_” (one log file per day).
* DB\_SQL\_LOGGING - Activates SQL logging. Log files are saved in “_storage/logs/sql_” (one log file per day).
* DEV\_SEEDER\_CREATE\_USER
* [PATH\_APACHE\_BINARY]
* [PATH\_PHP\_BINARY]



## Options

To use t

## Dependencies

* "php": "\*"
