<?php #CodeGenerator Δ 4ce09bfc6a41aa041e854134047fd12d Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-23 23:39:47
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @version     1.0.0 / 2025-04-23
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $Table) {
            $Table->id();

            $Table->foreignId('current_team_id')->nullable();
            $Table->string('email');
            $Table->timestamp('email_verified_at')->nullable();
            $Table->string('name');
            $Table->string('password');
            $Table->string('profile_photo_path', 2048)->nullable();
            $Table->rememberToken();

            $Table->unique('email', 'users_UKI_email');

            new CodeGenerator($Table, [
                'appends' => [
                    /*
                    **  Es wird keine Methode erzeugt, weil die entsprechende Methode bereits im Trait "HasProfilePhoto"
                    **  definiert ist. */
                    'profile_photo_url' => CodeGenerator::APPENDS_JSONAPI_SCHEMA + CodeGenerator::APPENDS_LARAVEL_MODEL_ARRAY,
                ],
                'columns' => [
                    'email' => [
                        'ruleType' => 'email',
                        'sortable' => true,
                    ],
                    'name' => [
                        'sortable' => true,
                    ],
                    'password' => [
                        'cast' => 'hashed',
                        'hidden' => true,
                    ],
                    'remember_token' => [
                        'guarded' => true,
                        'hidden' => true,
                    ],
                ],
                'exclude' => [
                    'csharp.jsonapiserializer',
                    'csharp.newtonsoftjsonapi',
                    'csharp.newtonsoft',
                    // 'jsonapi.derived.policy',
                    // 'jsonapi.derived.request',
                    // 'jsonapi.derived.schema',
                    'jsonapi.policy',
                    'jsonapi.request',
                    'jsonapi.route',
                    'jsonapi.schema',
                    'laravel.action.create',
                    'laravel.action.delete',
                    'laravel.action.update',
                    'laravel.controller',
                    // 'laravel.derived.model',
                    // 'laravel.derived.observer',
                    // 'laravel.derived.repository',
                    // 'laravel.derived.service',
                    'laravel.model',
                    'laravel.observer',
                    'laravel.repository',
                    'laravel.service',
                    'laravel.index',
                    'laravel.modal.add',
                    'laravel.modal.edit',
                    'laravel.user.migration',

                ],
                'extends' => [
                    'laravel.model' => 'Authenticatable',
                ],
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        //'Illuminate\\Contracts\\Auth\\MustVerifyEmail',
                        'Laravel\\Sanctum\\HasApiTokens',
                        'Laravel\\Jetstream\\HasProfilePhoto',
                        'Illuminate\\Notifications\\Notifiable',
                        'Laravel\\Fortify\\TwoFactorAuthenticatable',
                    ],
                ],
                'uses' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\\Models\\User as BaseUser',
                    ],
                ],
            ]);

        });

    } // up()


};
