<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */


 use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('countries');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('countries', function (Blueprint $Table) {
            $Table->id();

            $Table->boolean('active')->default(1);
            $Table->double('area')->nullable();
            $Table->json('capital_names')->nullable();
            $Table->string('comments', 2000)->nullable();
            $Table->string('fips10', 2)->nullable();
            $Table->string('ioc', 3)->nullable();
            $Table->string('iso3166_alpha_2', 2)->nullable();
            $Table->string('iso3166_alpha_3', 3)->nullable();
            $Table->string('iso3166_numeric', 3)->nullable();
            $Table->string('local_name', 150)->nullable();
            $Table->json('locales')->nullable()->comment('Locales in einem JSON-Array (["fr_BE", "nl_BE"]), auch wenn es nur einen einzigen Wert gibt (["de_DE"]).');
            $Table->json('long_names')->nullable();
            $Table->json('nationality_names')->nullable();
            $Table->string('nato_country_code_2', 2)->nullable();
            $Table->string('nato_country_code_3', 3)->nullable();
            $Table->json('short_names')->nullable();
            $Table->string('telephone_country_code', 5)->nullable();
            $Table->string('telephone_country_code_extended', 255)->nullable();
            $Table->string('tld', 3)->nullable();
            $Table->string('vehicle_registration_code', 3)->nullable();

            new CodeGenerator($Table, [
                'columns' => [
                    'active' => [
                        'filter' => true,
                        'sortable' => true,
                    ],
                    'capital_names' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_OBJECT,
                        'sortable' => true,
                    ],
                    'iso3166_alpha_2' => [
                        'sortable' => true,
                    ],
                    'iso3166_alpha_3' => [
                        'sortable' => true,
                    ],
                    'iso3166_numeric' => [
                        'sortable' => true,
                    ],
                    'locales' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_ARRAY,
                        'sortable' => true,
                    ],
                    'long_names' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_OBJECT,
                        'sortable' => true,
                    ],
                    'nationality_names' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_OBJECT,
                        'sortable' => true,
                    ],
                    'short_names' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_OBJECT,
                        'sortable' => true,
                    ],
                    'telephone_country_code' => [
                        'sortable' => true,
                    ],
                    'telephone_country_code_extended' => [
                        'sortable' => true,
                    ],
                ],
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],

            ]);

        });
    } // up()

};
