<?php
/**
 *
 * @version     2.0.$Revision: 3171 $
 * @version     SVN: $Id: TenantSeeder.php 3171 2024-06-03 16:03:47Z wassilios.meletiadis $
 * @package     Core\phpAPI
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2023, 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Database\Seeders\Dev;


use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;


use App\Models\Api\V2\Tenant;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        if (Tenant::find(1) === null) {
            DB::table('Tenant')->insert([

	array(
		"id" => 1,
		"uuid" => "aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa",
		"active" => 1,
		"created" => "2024-05-24 18:09:13",
		"deleted" => NULL,
		"modified" => "2024-05-24 18:09:13",
		"identifier" => "System",
		"master_id" => NULL,
	),
	array(
		"id" => 2,
		"uuid" => "b9994b2f-a886-4859-a8f9-1fbc9981b496",
		"active" => 1,
		"created" => "2024-05-24 18:13:26",
		"deleted" => NULL,
		"modified" => "2024-05-24 19:10:12",
		"identifier" => "Sportbund",
		"master_id" => 1,
	),
	array(
		"id" => 3,
		"uuid" => "a9ee596d-e79b-41f9-9f9e-7e83670a2466",
		"active" => 1,
		"created" => "2024-05-24 19:11:05",
		"deleted" => NULL,
		"modified" => "2024-05-24 19:11:05",
		"identifier" => "Landessportbund NRW",
		"master_id" => 2,
	),
	array(
		"id" => 4,
		"uuid" => "3dcec6b5-d520-45bf-b935-fd28f3b778d3",
		"active" => 1,
		"created" => "2024-05-24 19:13:38",
		"deleted" => NULL,
		"modified" => "2024-05-24 19:13:38",
		"identifier" => "Kreissportbund Porz",
		"master_id" => 3,
	),
	array(
		"id" => 5,
		"uuid" => "88e426b8-43a5-4747-bb83-5dce03a3530b",
		"active" => 1,
		"created" => "2024-05-24 19:14:20",
		"deleted" => NULL,
		"modified" => "2024-05-24 19:14:20",
		"identifier" => "Landessportbund RP",
		"master_id" => 2,
	),
	array(
		"id" => 6,
		"uuid" => "528f0746-7df3-4bd5-b1d6-cd7fece6a65f",
		"active" => 1,
		"created" => "2024-05-24 19:14:51",
		"deleted" => NULL,
		"modified" => "2024-05-24 19:14:51",
		"identifier" => "Kreissportbund Neuwied",
		"master_id" => 5,
	),

            ]);
        }
    } // run()

} // class TenantSeeder extends Seeder {}
