<?php

namespace BplanBase\Globals\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class GlobalsSetup extends Command
{
    protected $signature = 'globals:setup';

    protected $description = 'Installiert die Standarddateien aus dem MyPackage-Basispaket';

    public function handle()
    {
        $this->info('Kopiere Paket-Dateien ins Projekt...');

        Artisan::call('vendor:publish', [
            '--tag' => 'setup',
            '--force' => true,
        ]);

        $this->info(Artisan::output());

        $this->info('Installation abgeschlossen ✅');
    }
}