<?php
/**
 * Notification Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     MaxPlanck
 * @subpackage  Notifications
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Notifications;


use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;


/**
 * Notification Class
 *
 * Benachrichtigung an einen User über die Anlage seines Accounts (per E-Mail).
 *
 * @version     1.3.0 / 2025-01-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserCreated extends Notification
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use Queueable;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_password
     */
    private $_password;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Create a new notification instance.
     *
     * @param       string $password
     *
     * @version     1.0.0 / 2024-11-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(string $password)
    {
        $this->_password = $password;

    } // __construct()


    /**
     * Get the array representation of the notification.
     *
     * @param       object $Notifiable
     *
     * @return      array<string, mixed>
     *
     * @version     1.0.0 / 2024-11-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toArray(object $Notifiable): array
    {
        return [
            //
        ];
    } // toArray()


    /**
     * Get the mail representation of the notification.
     *
     * @param       object $Notifiable
     *
     * @throws      Exception
     *
     * @return      MailMessage
     *
     * @version     1.4.0 / 2025-01-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toMail(object $Notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject(trans('notifications.user-created.subject'))
            ->greeting(trans('notifications.greeting.user', ['username' => $Notifiable->name]))
            ->line(trans('notifications.user-created.intro'))
            ->line(trans('notifications.user-created.email', ['email' => $Notifiable->email]))
            ->line(trans('notifications.user-created.password', ['password' => $this->_password]))
            ->action(trans('Log in'), route('login'));

    } // toMail()


    /**
     * Get the notification's delivery channels.
     *
     * @param       object $Notifiable
     *
     * @return      array<int, string>
     *
     * @version     1.0.0 / 2024-11-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function via(object $Notifiable): array
    {
        return ['mail'];

    } // via()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class UserCreated extends Notification {}
