<?php
/**
 * Service Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-05 02:54:42
 * @package     bplan-base/globals
 * @subpackage  Services
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Services;


use BplanBase\Globals\Enums\LogLevel;
use Illuminate\Support\Facades\Log;


/**
 * Service Class
 *
 * @version     1.0.0 / 2025-04-05
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class LogService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function __construct() {
        //
    } // __construct()


    /**
     *
     * @param       LogLevel $logLevel
     *
     * @param       string $message
     *
     * @param       array $metadata
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function log(LogLevel $logLevel = LogLevel::Debug, string $message = '', array $metadata = []): void
    {
        // Write log to file
        switch ($logLevel) {
            case LogLevel::Alert:
                Log::alert($message, $metadata);
                break;

            case LogLevel::Critical:
                Log::critical($message, $metadata);
                break;

            case LogLevel::Debug:
                Log::debug($message, $metadata);
                break;

            case LogLevel::Emergency:
                Log::emergency($message, $metadata);
                break;

            case LogLevel::Error:
                Log::error($message, $metadata);
                break;

            case LogLevel::Info:
                Log::info($message, $metadata);
                break;

            case LogLevel::Notice:
                Log::notice($message, $metadata);
                break;

            case LogLevel::Warning:
                Log::warning($message, $metadata);
                break;

            default:
                Log::debug($message, $metadata);
                break;
        }
    } // log()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class LogService {}
