<?php
/**
 * Setup Commands Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Commands
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Console\Commands;


use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;


/**
 * Setup Commands Class
 *
 * @version     1.0.0 / 2025-05-03
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class GlobalsSetup extends Command
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $signature
     */
    protected $signature = 'globals:setup';


    /**
     * @var     string $description
     */
    protected $description = 'Installs the standard files from the Globals base package';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function handle()
    {
        /*
        **  Paketdateien publishen. */
        $this->info('Copy package files to project...');

        Artisan::call('vendor:publish', [
            '--tag' => 'setup-forced',
            '--force' => true,
        ]);
        $this->info(Artisan::output());

        Artisan::call('vendor:publish', [
            '--tag' => 'setup',
        ]);
        $this->info(Artisan::output());
        /*
        **  Storage-Link erzeugen. */
        $this->info('Link the storage directory...');

        Artisan::call('storage:link');

        $this->info(Artisan::output());

        $this->info('Installation completed ✅');

    } // handle()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class GlobalsSetup extends Command {}