# Globals

A package with global basic components such as locales, helper classes, enums, traits, etc.

## Installation

As the package is not in a public repository, the repository must be registered in the first installation step. To avoid having to register a separate repository for each private package, selected packages are made available via a central repository:

`composer config repositories.bplan-base/composer-packages composer https://satis.bplan.solutions`

The package can then be installed:

`composer require bplan-base/globals`

After installation, the following command must be executed:

```bash
php artisan globals:setup
```
This replaces various files in the project with customized versions and adds new files. The storage link is also created.

### Middlewares
The package includes a few middlewares for the api and web context. To use these middlewares in the project, changes to the “_bootstrap/app.php_” file are required.

```php

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        ...
    ) ->withMiddleware(function (Middleware $middleware) {

        $middleware->api(append: GlobalsServiceProvider::getApiMiddlewares());
        $middleware->web(append: GlobalsServiceProvider::getWebMiddlewares());
        ...
    })->withExceptions(function (Exceptions $exceptions) {
	...

```
These changes make the global middleware “LogApiRequest” available for the api routes and “SetLocale” for the web routes. 

As the name suggests, “LogApiRequest” ensures that API requests are written to a log file. The configuration option `API_LOG_LEVEL` can be used to control how extensive the logged data should be.
Possible settings are:
```
    0 = no logging, only in the event of an error
    1 = minimum log data,
	2 = extended log data,
	3 = complete log data.
```
Regardless of the log level set, complete data is always saved in the event of an error.

“SetLocale” sets the language of the application. The `“GET /locale/{locale}”` route is available for changing the language.

The package also provides middleware with the alias “_access-level.or.roles_”, which checks the access level and/or one or more roles of the logged-in user.
Usage:

```php
Route::middleware(\[
    'auth:sanctum',
    config('jetstream.auth\_session'),
    'verified',
    'access-level.or.roles:SystemManager,Host,Logistics'

\]) ...
```
In the previous example, “SystemManager” stands for an access level. One or more role names can be specified as further optional parameters. If only roles and no access level are to be checked, then “null” must be entered for the access level.


## Configuration

The package offers various configuration settings, all of which can be set via the _.env_ configuration file.

```toml
API_LOG_LEVEL = 0
```
Sets the level for API logging. Possible settings are:

* 0 = no logging, only in the event of an error
* 1 = notice, minimum log data
* 2 = info, extended log data
* 3 = debug, complete log data

Regardless of the log level set, complete data is always saved in the event of an error. Log files are saved in “_storage/logs/api_” (one log file per day).

```toml
DB_SQL_LOGGING = true
```
Activates SQL logging. Log files are saved in “_storage/logs/sql_” (one log file per day).

```toml
DEV_SEEDER_CREATE_USER = dev.user@example.com
```

```toml
PATH_APACHE_BINARY = "/.server/xampp/apache/bin/httpd.exe"
```

```toml
PATH_PHP_BINARY = "/.server/bin/php/8.latest/php.exe"
```


## Options

To use t...

## Dependencies

* "php": "\*"
