# Setup a new project

Diese Anleitung beschreibt die Einrichtung eines Laravel-Projekts als Basis für ein neues Projekt.

## Die Basis

Als Grundvoraussetzung für alle Projekte gilt das Paket bplan-base/globals. Dieses Paket benötigt eine Laravel-Installation mit Jetstream und Livewire.
Zur Einrichtung der Basis müssen nacheinander die folgenden Kommandos ausgeführt werden:

```bash
composer create-project laravel/laravel #example-app#

cd #example-app#

composer require laravel/jetstream

php artisan jetstream:install livewire --dark
```
Die Zeichenkette `#example-app#` muss durch den gewünschten Verzeichnisnamen ersetzt werden.

### bplan-Repository einrichten

Das folgende Kommando ergänzt die Datei composer.json um eine neue Sektion repositories, mit der URL des bplan-Repositories. Dadurch wird es möglich private Pakete von dort zu installieren.

```bash
composer config repositories.bplan-base/composer-packages composer https://satis.bplan.solutions
```

### Lokale Entwicklung

Die Ausführung dieses Schritts ist nicht zwingend erforderlich.
Um lokal Pakete einzubinden, die nicht fester Bestandteil des Projekts sind oder sein sollen, kann das Paket "wikimedia/composer-merge-plugin" installiert werden. Das ermöglicht es Pakete in einer ausgelagerten Composer-Konfiguration zu definieren. Dieser Installationsschritt kann bei Bedarf zu einem späteren Zeitpunkt nachgeholt werden.

```bash
composer require wikimedia/composer-merge-plugin
```
Bei der Installation dieses Pakets wird eine Warnung ausgegeben die besagt, dass das Paket ein Composer Plugin enthält, das zu "allow-plugins" hinzugefügt werden soll. Hier muss mit "y" bestätigt werden.

Eine Vorlage für die Konfigurationsdatei wird in einem der späteren Setup-Schritte zum Projekt hinzugefügt.

### Globals-Paket installieren

Mit der Installation des Globals Pakets werden viele Basis-Funktionalitäten installiert …

```bash
composer require bplan-base/globals
```

Nach der Installation muss das Setup des Globals Pakets ausgeführt werden, das ein paar Dateien im Projekt ersetzt und weitere Dateien hinzufügt.

```bash
php artisan globals:setup
```

### Code Generator installieren

Der Code Generator erzeugt automatisiert Klassen zu speziell aufbereiteten Migrations. Wenn das neue Projekt über keine Migrations verfügt, dann kann dieser Installationsschritt ausgelassen werden. Die Installation des Code Generators kann zu einem späteren Zeitpunkt nachgeholt werden.

```bash
composer require bplan-base/laravel-code-generator:@dev
```
Der Code Generator wird als Dev-Dependency hinzugefügt, so dass er später, bei der Einrichtung des Projekt auf einem produktiven System, nicht mit installiert wird, wenn dort die Installation mit dem Parameter `--no-dev` ausgeführt wird.

Um den Code Generator zu aktivieren, ist die folgende Konfigurationseinstellung in der .env Datei des Projekts erforderlich:

```toml
CODE_GENERATOR_ACTIVE = true
```
Die Verwendung des Code Generators ist in der zugehörigen README-Datei beschrieben.
