<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\Globals\Http\Controllers\CountryController;
use BplanBase\Globals\Http\Controllers\DemoController;
use BplanBase\Globals\Http\Controllers\LocaleController;
use BplanBase\Globals\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;


/**
 * Admin role needed
 */
Route::middleware([
    'web',
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
    'access-level.or.roles:SystemManager,Admin',

])->group(function () {
    Route::get('/countries', [CountryController::class, 'index'])->name('countries.index');
    Route::get('/users',     [UserController::class, 'index'])->name('users.index');
});


if (str_starts_with(strtolower(config('app.env')), 'demo') === true) {
    /**
     * AccessLevel "SystemManager" needed
     */
    Route::middleware([
        'web',
        'auth:sanctum',
        config('jetstream.auth_session'),
        'verified',
        'access-level.or.roles:SystemManager',

    ])->group(function () {
        Route::get('/demo-reset-page',   [DemoController::class, 'showResetPage']);
        Route::get('/demo-reset-stream', [DemoController::class, 'streamReset']);
    });
}

Route::middleware(['web'])->group(function () {
    Route::get('/locale/{locale}', [LocaleController::class, 'setLocale'])->name('locale.set');
});
