<?php
/**
 * Policy Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Policies
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Policies;


use BplanBase\Globals\Models\Setting;
use BplanBase\Globals\Models\User;
use Illuminate\Auth\Access\Response;


/**
 * Policy Class
 *
 * @version     1.0.0 / 2025-05-03
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class SettingPolicy
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Determine whether the user can create models.
     *
     * @param       User $User
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(User $User): bool
    {
        return true;

    } // create()


    /**
     * Determine whether the user can delete the model.
     *
     * @param       User $User
     *
     * @param       Setting $Setting
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(User $User, Setting $Setting): bool
    {
        return true;

    } // delete()


    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param       User $User
     *
     * @param       Setting $Setting
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDelete(User $User, Setting $Setting): bool
    {
        return true;

    } // forceDelete()


    /**
     * Determine whether the user can restore the model.
     *
     * @param       User $User
     *
     * @param       Setting $Setting
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restore(User $User, Setting $Setting): bool
    {
        return true;

    } // restore()


    /**
     * Determine whether the user can update the model.
     *
     * @param       User $User
     *
     * @param       Setting $Setting
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function update(User $User, Setting $Setting): bool
    {
        return true;

    } // update()


    /**
     * Determine whether the user can view the model.
     *
     * @param       User $User
     *
     * @param       Setting $Setting
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function view(User $User, Setting $Setting): bool
    {
        return true;

    } // view()


    /**
     * Determine whether the user can view any models.
     *
     * @param       User $User
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-05-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function viewAny(User $User): bool
    {
        return true;

    } // viewAny()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class SettingPolicy {}
