<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $Table) {
            $Table->id();

            $Table->foreignId('current_team_id')->nullable();
            $Table->string('email');
            $Table->timestamp('email_verified_at')->nullable();
            $Table->string('name');
            $Table->string('password');
            $Table->string('profile_photo_path', 2048)->nullable();
            $Table->rememberToken();

            $Table->unique('email', 'users_UKI_email');

            new CodeGenerator($Table, [
                'appends' => [
                    /*
                    **  Es wird keine Methode erzeugt, weil die entsprechende Methode bereits im Trait "HasProfilePhoto"
                    **  definiert ist. */
                    'profile_photo_url' => CodeGenerator::APPENDS_JSONAPI_SCHEMA + CodeGenerator::APPENDS_LARAVEL_MODEL_ARRAY,
                ],
                'columns' => [
                    'email' => [
                        'ruleType' => 'email',
                        'sortable' => true,
                    ],
                    'name' => [
                        'sortable' => true,
                    ],
                    'password' => [
                        'cast' => 'hashed',
                        'hidden' => true,
                    ],
                    'remember_token' => [
                        'guarded' => true,
                        'hidden' => true,
                    ],
                ],
                'exclude' => [
                    // 'jsonapi.policy',
                    // 'jsonapi.request',
                    // 'jsonapi.schema',
                    // 'laravel.action.create',
                    // 'laravel.action.delete',
                    // 'laravel.action.update',
                    // 'laravel.controller',
                    // 'laravel.model',
                    // 'laravel.observer',
                    // 'laravel.repository',
                    // 'laravel.service',
                    'livewire.index',
                    'livewire.modal.add',
                    'livewire.modal.edit',

                ],
                'extends' => [
                    'laravel.model' => 'Authenticatable',
                ],
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'Illuminate\\Contracts\\Auth\\MustVerifyEmail',
                        'Illuminate\\Notifications\\Notifiable',
                        'Laravel\\Sanctum\\HasApiTokens',
                        'Laravel\\Jetstream\\HasProfilePhoto',
                        'Laravel\\Fortify\\TwoFactorAuthenticatable',
                        'Laravel\\Sanctum\\HasApiTokens',
                    ],
                ],
                'uses' => [
                    'laravel.model' => [
                        // 'BplanBase\\Globals\\Models\\User as BaseUser',
                        'App\\Observers\\UserObserver',
                        'BplanBase\\Globals\\Enums\\UserAccessLevel',
                        'Illuminate\\Foundation\\Auth\User as Authenticatable',
                        'Illuminate\\Notifications\\Notification',
                        'Illuminate\\Support\\Str',
                    ],
                ],
            ]);

        });

    } // up()


};
