<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{

    /**
     * Reverse the migrations.
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function down(): void
    {
        Schema::dropIfExists('tenant_records');

    } // down()


    /**
     * Run the migrations.
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function up(): void
    {
        Schema::create('tenant_records', function (Blueprint $Table) {
            $Table->foreignId('id')->constrained(table: 'tenants', indexName: 'tenant_records_PK');
            $Table->uuid('uuid');
            $Table->boolean('active')->default(1);

            $Table->timestamps();
            $Table->softDeletes('deleted_at');

            $Table->string('city', 50)->nullable();
            $Table->string('company', 100);
            $Table->foreignId('country_id')->nullable()->constrained(table: 'countries', indexName: 'tenant_records_FK_country_id');
            $Table->text('description')->nullable();
            $Table->string('email', 255)->nullable();
            $Table->string('home_page', 255)->nullable();
            $Table->string('house_number', 5)->nullable();
            $Table->string('mobile_phone_number', 30)->nullable();
            $Table->string('mobile_phone_number_country_code', 5)->nullable();
            $Table->string('phone_number', 30)->nullable();
            $Table->string('phone_number_country_code', 5)->nullable();
            $Table->string('street', 100)->nullable();
            $Table->string('zip_code', 10)->nullable();

            $Table->index('id',         'tenant_records_FKI_id');
            $Table->index('country_id', 'tenant_records_FKI_country_id');

            new CodeGenerator($Table, [
                'columns' => [
                    'id' => [
                        'relationName' => 'tenant',
                        'reverseRelationType' => 'HasOne',
                    ],
                    'uuid' => [
                        'guarded' => true,
                    ],
                    'active' => [
                        'sortable' => true,
                    ],
                    'company' => [
                        'sortable' => true,
                    ],
                ],
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],

            ]);

        });

    } // up()

};
