<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DatabaseSeeder extends Seeder
{


    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $env = strtolower(config('app.env'));

        if ($env === 'production') {
            $seeds = [
                CountrySeeder::class,
                TenantSeeder::class,
                TenantRecordSeeder::class,
                TenantLocaleSeeder::class,
                RoleSeeder::class,
                UserSeeder::class,
                UserRecordSeeder::class,
                RoleUserSeeder::class,
            ];
        } elseif (str_starts_with($env, 'demo') === true) {
            $seeds = [
                CountrySeeder::class,
                TenantSeeder::class,
                TenantRecordSeeder::class,
                TenantLocaleSeeder::class,
                RoleSeeder::class,
                UserSeeder::class,
                Dev\UserSeeder::class,
                Demo\UserSeeder::class,
                UserRecordSeeder::class,
                Dev\UserRecordSeeder::class,
                Demo\UserRecordSeeder::class,
                RoleUserSeeder::class,
                Demo\RoleUserSeeder::class,
            ];
        } else {
            $seeds = [
                CountrySeeder::class,
                TenantSeeder::class,
                TenantRecordSeeder::class,
                TenantLocaleSeeder::class,
                RoleSeeder::class,
                UserSeeder::class,
                Dev\UserSeeder::class,
                UserRecordSeeder::class,
                Dev\UserRecordSeeder::class,
                RoleUserSeeder::class,
            ];
        }
        $this->call($seeds);

    } // run()


} // class DatabaseSeeder extends Seeder
