<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');

            $Table->timestamps();

            $Table->string('context', 50);
            $Table->string('key', 50);
            $Table->text('value')->nullable();

            $Table->unique(['context', 'key'], 'settings_UKI_context_key');

            new CodeGenerator($Table, [
                'exclude' => [
                    'laravel.action.create',
                    'laravel.action.delete',
                    'laravel.action.update',
                    'laravel.controller',
                    'laravel.model',
                    'laravel.observer',
                    'laravel.repository',
                    // 'laravel.service',
                    'livewire.index',
                    'livewire.modal.add',
                    'livewire.modal.edit',

                ],
            ]);

        });

    } // up()

};
