<?php
/**
 * Make Helper Trait
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Traits
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Traits;


/**
 * Make Helper Trait
 *
 * @version     1.0.0 / 2025-05-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
trait MakeHelpers
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $config
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2025-05-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getCopyrightReplacement(array $config): string
    {
        $copyright = $config['copyright'];
        $devStart = $config['devStart'];

        $currentYear = (int) date('Y');

        if ($devStart === $currentYear) {
            $copyright = $devStart.' '.$copyright;

        } elseif ($devStart === ($currentYear - 1)) {
            $copyright = $devStart.', '.$currentYear.' '.$copyright;

        } else {
            $copyright = $devStart.' - '.$currentYear.' '.$copyright;
        }
        return $copyright;

    } // _getCopyrightReplacement()


    /**
     *
     * @param       array $authors
     *
     * @param       string $stub
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2025-05-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _replaceAuthorPlaceholder(array $authors, string $stub): string
    {
        for ($i = 0; $i < 2; $i++) {
            $placeholder = 'author-'.$i;

            $j = 0;
            $padding = str_repeat(' ', 4 * $i);
            $replacement = '';

            foreach ($authors as $author) {
                if ($j === 0) {
                    $replacement .= $author;
                } else {
                    $replacement .= "\n".$padding.' * @author      '.$author;
                }
                $j++;
            }
            if ($i === 0) {
                $stub = $this->_replacePlaceholder('author', $replacement, $stub);
            }
            $stub = $this->_replacePlaceholder($placeholder, $replacement, $stub);
        }
        return $stub;

    } // _replaceAuthorPlaceholder()


    /**
     * Ersetzt Platzhalter durch die übergebene Zeichenkette
     *
     * @param       string $placeholder
     *
     * @param       string $replace
     *
     * @param       string $subject
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2025-05-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _replacePlaceholder(string $placeholder, string $replace, string $subject): string
    {
        $placeholder = [
            '{{'.$placeholder.'}}',
            '{{ '.$placeholder.' }}',
        ];
        return str_replace($placeholder, $replace, $subject);

    } // _replacePlaceholder()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // trait MakeHelpers {}
