# Globals

A package with global basic components such as locales, helper classes, enums, traits, etc.

## Installation

As the package is not in a public repository, the repository must be registered in the first installation step. To avoid having to register a separate repository for each private package, selected packages are made available via a central repository:
```bash
composer config repositories.bplan-base/composer-packages composer https://satis.bplan.solutions
```

The package can then be installed:
```bash
composer require bplan-base/globals
```

After the installation, the setup of the Globals package can be started:
```bash
php artisan globals:setup
```
Executing the command performs the following tasks in the project directory:

* Replacing some default files.
* Adding new files.
* Creating the storage link.
* Installing and setting up the “wikimedia/composer-merge-plugin” package.

### Middlewares

The package includes a few middlewares for the api and web context. To use these middlewares in the project, changes to the `bootstrap/app.php` file are required.
```php

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        ...
    ) ->withMiddleware(function (Middleware $middleware) {

        $middleware->api(append: GlobalsServiceProvider::getApiMiddlewares());
        $middleware->web(append: GlobalsServiceProvider::getWebMiddlewares());
        ...
    })->withExceptions(function (Exceptions $exceptions) {
	...

```
These changes make the global middleware “LogApiRequest” available for the api routes and “SetLocale” for the web routes. 

As the name suggests, “LogApiRequest” ensures that API requests are written to a log file. The configuration option `API_LOG_LEVEL` can be used to control how extensive the logged data should be.
Possible settings are:
```
    0 = no logging, only in the event of an error
    1 = minimum log data,
	2 = extended log data,
	3 = complete log data.
```
Regardless of the log level set, complete data is always saved in the event of an error.

“SetLocale” sets the language of the application. The `“GET /locale/{locale}”` route is available for changing the language.

The package also provides middleware with the alias `access-level.or.roles`, which checks the access level and/or one or more roles of the logged-in user.
Usage:
```php
Route::middleware(\[
    'auth:sanctum',
    config('jetstream.auth\_session'),
    'verified',
    'access-level.or.roles:SystemManager,Host,Logistics'

\]) ...
```
In the previous example, “SystemManager” stands for an access level. One or more role names can be specified as further optional parameters. If only roles and no access level are to be checked, then “null” must be entered for the access level.


## Configuration

The package offers various configuration settings, all of which can be set via the `.env` configuration file.

Configure API logging:
```toml
API_LOG_LEVEL = 0
```
Sets the level for API logging. Possible settings are:

* 0 = no logging, only in the event of an error
* 1 = notice, minimum log data
* 2 = info, extended log data
* 3 = debug, complete log data

Regardless of the log level set, complete data is always saved in the event of an error. Log files are saved in `storage/logs/api` (one log file per day).

Activate SQL logging:
```toml
DB_SQL_LOGGING = true
```
Activates SQL logging. Log files are saved in `storage/logs/sql` (one log file per day).

Define seeding user:
```toml
DEV_SEEDER_CREATE_USER = dev.user@example.com
```

Configure the path to the Apache executable:
```toml
PATH_APACHE_BINARY = "/path/to/apache/bin/httpd.exe"
```
This setting defaults to `/.server/xampp/apache/bin/httpd.exe`.

Configure the path to the PHP executable:
```toml
PATH_PHP_BINARY = "/path/to/php.exe"
```
This setting defaults to `/.server/bin/php/8.latest/php.exe`.


## Options

To use t...

## Dependencies

* "php": "*",
* "bplan-base/laravel-code-generator-loader": "*"
