<?php
/**
 *
 * @version     2.0.$Revision: 3146 $
 * @version     SVN: $Id: RoleSeeder.php 3146 2024-05-25 22:41:21Z wassilios.meletiadis $
 * @package     Core\phpAPI
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2023, 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Database\Seeders\Dev;


use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;


use App\Models\Api\V2\Role;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RoleSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        if (Role::find(1) === null) {
            $date = date('Y-m-d H:i:s');

            DB::table('Role')->insert([

                [
                    "id" => 1,
                    "uuid" => "aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaa1",
                    "active" => 1,
                    "created" => $date,
                    "deleted" => NULL,
                    "modified" => $date,
                    "name" => "Administrator",
                    "tenant_id" => 1,
                ], [
                    "id" => 2,
                    "uuid" => "aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaa2",
                    "active" => 1,
                    "created" => $date,
                    "deleted" => NULL,
                    "modified" => $date,
                    "name" => "Manager",
                    "tenant_id" => 1,
                ], [
                    "id" => 3,
                    "uuid" => "aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaa3",
                    "active" => 1,
                    "created" => $date,
                    "deleted" => NULL,
                    "modified" => $date,
                    "name" => "User",
                    "tenant_id" => 1,
                ],
                array(
                    "id" => 4,
                    "uuid" => "1",
                    "active" => 1,
                    "created" => $date,
                    "deleted" => NULL,
                    "modified" => $date,
                    "name" => "Administrator",
                    "tenant_id" => 2,
                ),
                array(
                    "id" => 5,
                    "uuid" => "2",
                    "active" => 1,
                    "created" => $date,
                    "deleted" => NULL,
                    "modified" => $date,
                    "name" => "Manager",
                    "tenant_id" => 2,
                ),
                array(
                    "id" => 6,
                    "uuid" => "3",
                    "active" => 1,
                    "created" => $date,
                    "deleted" => NULL,
                    "modified" => $date,
                    "name" => "User",
                    "tenant_id" => 2,
                ),
                array(
                    "id" => 7,
                    "uuid" => "1",
                    "active" => 1,
                    "created" => $date,
                    "deleted" => NULL,
                    "modified" => $date,
                    "name" => "Administrator",
                    "tenant_id" => 3,
                ),
                array(
                    "id" => 8,
                    "uuid" => "2",
                    "active" => 1,
                    "created" => $date,
                    "deleted" => NULL,
                    "modified" => $date,
                    "name" => "Manager",
                    "tenant_id" => 3,
                ),
                array(
                    "id" => 9,
                    "uuid" => "3",
                    "active" => 1,
                    "created" => $date,
                    "deleted" => NULL,
                    "modified" => $date,
                    "name" => "User",
                    "tenant_id" => 3,
                ),

            ]);
        }
    } // run()

} // class RoleSeeder extends Seeder {}
