<?php
/**
 *
 * @version     2.0.$Revision: 3081 $
 * @version     SVN: $Id: TenantLocaleSeeder.php 3081 2024-05-04 01:49:34Z wassilios.meletiadis $
 * @package     Core\phpAPI
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2023, 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Database\Seeders\Dev;


use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;


use App\Models\Api\V2\TenantLocale;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantLocaleSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        if (TenantLocale::find(1) === null) {
            DB::table('TenantLocale')->insert([

                [
                    "id" => 1,
                    "uuid" => "aaaaaaaa-aaaa-aaaa-aaaa-000000000001",
                    "active" => 1,
                    "keyIndex" => 1,
                    "locale" => "de_DE",
                    "main" => 1,
                    "tenant_id" => 1,
                ], [
                    "id" => 2,
                    "uuid" => "aaaaaaaa-aaaa-aaaa-aaaa-000000000002",
                    "active" => 1,
                    "keyIndex" => 2,
                    "locale" => "en_GB",
                    "main" => 0,
                    "tenant_id" => 1,
                ], [
                    "id" => 3,
                    "uuid" => "aaaaaaaa-aaaa-aaaa-aaaa-000000000003",
                    "active" => 1,
                    "keyIndex" => 3,
                    "locale" => "fr_FR",
                    "main" => 0,
                    "tenant_id" => 1,
                ],
                array(
                    "id" => 4,
                    "uuid" => "13d5a525-c24f-47d2-bf0a-25ea718ddcc8",
                    "active" => 1,
                    "keyIndex" => 2,
                    "locale" => "en_GB",
                    "main" => 0,
                    "tenant_id" => 2,
                ),
                array(
                    "id" => 5,
                    "uuid" => "xxx",
                    "active" => 1,
                    "keyIndex" => 1,
                    "locale" => "de_DE",
                    "main" => 0,
                    "tenant_id" => 3,
                ),
                array(
                    "id" => 6,
                    "uuid" => "tenant-3-locale-2",
                    "active" => 1,
                    "keyIndex" => 2,
                    "locale" => "en_GB",
                    "main" => 1,
                    "tenant_id" => 3,
                ),
                array(
                    "id" => 7,
                    "uuid" => "tenant-4-locale-1",
                    "active" => 1,
                    "keyIndex" => 1,
                    "locale" => "de_DE",
                    "main" => 1,
                    "tenant_id" => 4,
                ),
                array(
                    "id" => 8,
                    "uuid" => "tenant-4-locale-2",
                    "active" => 1,
                    "keyIndex" => 2,
                    "locale" => "en_GB",
                    "main" => 0,
                    "tenant_id" => 4,
                ),

            ]);
        }
    } // run()

} // class TenantLocaleSeeder extends Seeder {}
