<?php
/**
 *
 * @version     2.0.$Revision: 3353 $
 * @version     SVN: $Id: UserTenantAccessSeeder.php 3353 2025-04-05 00:51:17Z wassilios.meletiadis $
 * @package     Core\phpAPI
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2023, 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Database\Seeders\Dev;


use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;


use App\Models\Api\V2\UserTenantAccess;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserTenantAccessSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        if (UserTenantAccess::find(1) === null) {
            DB::table('UserTenantAccess')->insert([

	array(
		"id" => 1,
		"uuid" => "1",
		"created" => $date,
		"modified" => $date,
		"accessLevel" => 'Staff',
		"tenant_id" => 3,
		"user_id" => 6,
	),
	array(
		"id" => 2,
		"uuid" => "2",
		"created" => $date,
		"modified" => $date,
		"accessLevel" => 'Staff',
		"tenant_id" => 4,
		"user_id" => 6,
	),
	array(
		"id" => 3,
		"uuid" => "3",
		"created" => $date,
		"modified" => $date,
		"accessLevel" => 'Staff',
		"tenant_id" => 5,
		"user_id" => 7,
	),
	array(
		"id" => 4,
		"uuid" => "4",
		"created" => $date,
		"modified" => $date,
		"accessLevel" => 'Staff',
		"tenant_id" => 6,
		"user_id" => 7,
	),

            ]);
        }
    } // run()

} // class UserTenantAccessSeeder extends Seeder {}
