<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use App\Models\User;
use BplanBase\Globals\Enums\UserAccessLevel;
use BplanBase\Globals\Models\Tenant;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');
        $env = strtolower(config('app.env'));

        $Tenant = Tenant::where('identifier', 'System')->first();

        $users = [
            [
                'id' => 1,
                'uuid' => 'aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaa1',
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'access_level' => UserAccessLevel::System->name,
                'email' => 'system@bplan-solutions.de',
                'internal' => 1,
                'name' => 'system',
                'tenant_id' => $Tenant->id,
            ], [
                'id' => 2,
                'uuid' => 'aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaa2',
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'access_level' => UserAccessLevel::Developer->name,
                'email' => 'developer@bplan-solutions.de',
                'internal' => 1,
                'name' => 'developer',
                'tenant_id' => $Tenant->id,
            ], [
                'id' => 3,
                'uuid' => 'aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaa3',
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'access_level' => UserAccessLevel::Maintainer->name,
                'email' => 'maintainer@bplan-solutions.de',
                'internal' => 1,
                'name' => 'maintainer',
                'tenant_id' => $Tenant->id,
            ], [
                'id' => 4,
                'uuid' => 'aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaa4',
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'access_level' => UserAccessLevel::Guest->name,
                'email' => 'guest@bplan-solutions.de',
                'internal' => 1,
                'name' => 'guest',
                'tenant_id' => $Tenant->id,
            ],
        ];
        $outputs = [];
        $setupLog = '';

        foreach ($users as & $user) {
            if ($env === 'production') {
                $password = Str::random(12);
            } else {
                $password = 'Test!234';
            }
            if ($user['name'] === 'guest' || $user['name'] === 'system') {
                $user['password'] = '';

            } else {
                $user['password'] = Hash::make($password);

                $outputs[] = [
                    'username' => $user['email'],
                    'password' => $password
                ];
                $setupLog .= $user['email'].'/'.$password."\n";
            }
        }
        User::insert($users);

        $this->command->info("\n");

        foreach ($outputs as $output) {
            $this->command->info('    '.$output['username'].'/'.$output['password']);
            $setupLog .= $output['username'].'/'.$output['password']."\n";
        }
        $this->command->info("\n");

        file_put_contents(
            storage_path('logs/setup.log'),
            $setupLog,
            FILE_APPEND
        );
        $this->command->info('    Setup log written to: '.storage_path('logs/setup.log')."\n");
        $this->command->info('    Base user seeder completed successfully.'.'\n');

    } // run()


} // class UserSeeder extends Seeder {}
