<?php
/**
 * Middleware Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Middlewares
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Middleware;


use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use Symfony\Component\HttpFoundation\Response;


/**
 * Middleware Class
 *
 * @version     1.0.0 / 2025-04-15
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class SetLocale
{

    /**
     * Handle an incoming request.
     *
     * @param       Request $Request
     *
     * @param       Closure $Next
     *
     * @return      Response
     *
     * @version     1.0.0 / 2025-04-15
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function handle(Request $Request, Closure $Next): Response
    {
        app()->setLocale(Cookie::get('app_locale') ?: config('app.locale'));

        return $Next($Request);

    } // handle()


} // class SetLocale {}
