<?php
/**
 * Service Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-05 02:58:43
 * @package     bplan-base/globals
 * @subpackage  Services
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Services;


use App\Models\RoleUser as DerivedRoleUser;
use BplanBase\Globals\Actions\RoleUser\Create;
use BplanBase\Globals\Actions\RoleUser\Delete;
use BplanBase\Globals\Actions\RoleUser\DeleteUserRoles;
use BplanBase\Globals\Models\RoleUser;


/**
 * Service Class
 *
 * @version     1.1.0 / 2025-04-05
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RoleUserService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $attributes
     *
     * @return      RoleUser
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(array $attributes): RoleUser|DerivedRoleUser
    {
        $Action = new Create();

        return $Action->execute($attributes);

    } // create()


    /**
     *
     * @param       int|string|RoleUser|DerivedRoleUser $roleUser
     *
     * @return      RoleUser
     *
     * @version     2.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(int|string|RoleUser|DerivedRoleUser $roleUser): RoleUser|DerivedRoleUser
    {
        $Action = new Delete();

        return $Action->execute($roleUser);

    } // delete()


    /**
     *
     * @param       RoleUser|DerivedRoleUser $user
     *
     * @return      int
     *
     * @version     1.0.0 / 2025-04-15
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleteUserRoles(RoleUser|DerivedRoleUser $user): int
    {
        $Action = new DeleteUserRoles();

        return $Action->execute($user);

    } // deleteUserRoles()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class RoleUserService {}
