<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\Demo;


use BplanBase\Globals\Models\Country;
use BplanBase\Globals\Models\Role;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Models\TenantLocale;
use BplanBase\Globals\Models\TenantRecord;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 * Seeder Class
 *
 * Seed demo tenant with tenant record, locales and roles.
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CombinedTenantSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        $SystemTenant = Tenant::where('identifier', '=', 'System')->first();

        Tenant::insert([
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'identifier' => 'DemoTenant',
                'master_id' => $SystemTenant->id,
            ],

        ]);
        $Country = Country::where('iso3166_alpha_2', '=', 'DE')->first();
        $DemoTenant = Tenant::where('identifier', '=', 'DemoTenant')->first();

        TenantRecord::insert([
            [
                'id' => $DemoTenant->id,
                'uuid' => $DemoTenant->uuid,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'city' => 'Köln',
                'company' => 'Demo AG',
                'country_id' => $Country->id,
                'description' => null,
                'email' => 'demo@bplan-solutions.de',
                'home_page' => 'https://www.bplan-solutions.de/',
                'house_number' => '1',
                'phone_number' => '22039898980',
                'phone_number_country_code' => '+49',
                'street' => 'Hauptstrasse',
                'zip_code' => '51147',
            ],

        ]);

        TenantLocale::insert([
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'key_index' => 1,
                'locale' => 'de',
                'main' => 1,
                'tenant_id' => $DemoTenant->id,
            ], [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'key_index' => 2,
                'locale' => 'en',
                'main' => 0,
                'tenant_id' => $DemoTenant->id,
            ],
        ]);

        Role::insert([
            [
                'uuid' => Str::uuid(),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => 'Admin',
                "internal" => 1,
                "labels" => '{"de": "Administrator", "en": "Administrator", "it": "Amministratore"}',
                'tenant_id' => $DemoTenant->id,
            ],

        ]);

    } // run()

} // class CombinedTenantSeeder extends Seeder {}
