<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\EntityTypes;


use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Models\EntityTypeModel;
use BplanBase\Globals\Models\Module;
use BplanBase\Globals\Models\Tenant;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class IndividualEmployeeSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        $Tenant = Tenant::where('identifier', '=', 'System')->first();
        $EntityTypeIndividual = EntityType::where('identifier', '=', 'Individual')->first();

        EntityType::insert([
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'abstract' => 0,
                'identifier' => 'Individual.Employee',
                'labels' => '{"de": "Mitarbeiter", "en": "Employees"}',
                'main_type' => 'Individual',
                'master_id' => $EntityTypeIndividual->id,
                'model_id' => $EntityTypeIndividual->model_id,
                'module_id' => $EntityTypeIndividual->module_id,
                'private' => 0,
                'resource_name' => 'individual-employees',
                'source_id' => $EntityTypeIndividual->id,
                'sub_type' => 'Employee',
                'tenant_id' => $Tenant->id,
            ],

        ]);

    } // run()

} // class IndividualEmployeeSeeder extends Seeder {}
