<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Locales
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use Carbon\WeekDay;


return [

    'iso-3166-1-alpha-2' => 'gb',
    'language' => 'English',
    'locale' => 'en_GB',

    'currency.decimals'        => "2",
    'currency.format.string'   => '£:value',
    'currency.format.negative' => '-£:value',
    'currency.iso4217.alpha'   => 'GBP',
    'currency.iso4217.numeric' => 826,
    'currency.name'            => 'British Pound',
    'currency.subunit.divisor' => 100,
    'currency.subunit.name'    => 'Penny',
    'currency.subunit.symbol'  => 'p',
    'currency.symbol'          => '£',

    'date.format'       => 'd/m/Y',
    'datetime.format'   => 'd/m/Y H:i',
    'datetime.format+'  => 'd/m/Y H:i:s',
    'datetime.format-+' => 'd/m/Y H:i',
    'datetime.format++' => 'd/m/Y H:i:s',
    'time.format'       => 'H:i',
    'time.format+'      => 'H:i:s',
    'time.format-+'     => 'H:i',
    'time.format++'     => 'H:i:s',

    'number.decimal-point'       => '.',
    'number.thousands-separator' => ',',

    'text.direction'    => 'ltr',
    'text.orientation'  => 'sideways',
    'text.writing-mode' => 'vertical-rl',

    // -------------------------------------------------------------------


    'action.activate'      => 'Activate',
    'action.add'           => 'Add',
    'action.back'          => 'Back',
    'action.cancel'        => 'Cancel',
    'action.cancel-upload' => 'Cancel Upload',
    'action.change'        => 'Change',
    'action.close'         => 'Close',
    'action.confirm'       => 'Confirm',
    'action.copy'          => 'Copy',
    'action.create'        => 'Create',
    'action.deactivate'    => 'Deactivate',
    'action.delete'        => 'Delete',
    'action.edit'          => 'Edit',
    'action.export'        => 'Export',
    'action.import'        => 'Import',
    'action.instantiate'   => 'Instantiate',
    'action.link'          => 'Link',
    'action.logout'        => 'Logout',
    'action.print'         => 'Print',
    'action.save'          => 'Save',
    'action.save-and-back' => 'Save & Back',
    'action.search'        => 'Search',
    'action.sync'          => 'Sync',
    'action.to-top'        => 'To Top',
    'action.unlink'        => 'Unlink',
    'action.upload'        => 'Upload File',
    'action.verify'        => 'Verify',
    'action.view'          => 'View',

    'caption.action'     => 'Action',
    'caption.active'     => 'Active',
    'caption.created_at' => 'Created at',
    'caption.deleted_at' => 'Deleted at',
    'caption.email'      => 'EMail',
    'caption.id'         => 'ID',
    'caption.label'      => 'Label',
    'caption.labels'     => 'Labels',
    'caption.name'       => 'Name',
    'caption.updated_at' => 'Updated at',
    'caption.uuid'       => 'UUID',

    'confirm.delete'         => 'Are you sure you want to delete this item?',
    'confirm.delete.caption' => 'Please confirm',
    'confirm.delete.message' => 'Do you really want to delete this object?',

    'error.db-save-error' => 'An error occured. Please try again later.',

    'error.auto-logout'                  => 'You have been logged out because your access is disabled or restricted.',
    'error.auto-logout.account-inactive' => 'You have been logged out because your user account is disabled.',
    'error.auto-logout.no-active-tenant' => 'You have been logged out because there are no active tenants available for your user account.',
    'error.auto-logout.no-tenant'        => 'You have been logged out because there are no tenants available for your user account.',

    'heading.attention' => 'Attention',
    'heading.error'     => 'Error',
    'heading.notice'    => 'Notice',
    'heading.warning'   => 'Warning',

    'label.action' => 'Action',
    'label.active' => 'Active',
    'label.email'  => 'Email',
    'label.id'     => 'ID',
    'label.label'  => 'Label',
    'label.labels' => 'Labels',
    'label.name'   => 'Name',
    'label.uuid'   => 'UUID',

    'languages' => [
        'bg' => 'Bulgarian',
        'de' => 'German',
        'en' => 'English',
        'es' => 'Spanish',
        'fr' => 'French',
        'hu' => 'Hungarian',
        'it' => 'Italian',
        'lt' => 'Lithuanian',
        'lv' => '',
        'pl' => 'Polish',
        'ro' => 'Romanian',
        'ru' => 'Russian',
        'tr' => 'Turkish',
        'uk' => 'Ukrainian',
    ],

    'log.action' => ':action by :user (:email)',

    'notification.data-saved'     => 'The object has been successfully saved.',
    'notification.data-unchanged' => 'The object has not been changed.',

    'option.yes' => 'Yes',
    'option.no'  => 'No',

    'pagination.next'     => 'Next &raquo;',
    'pagination.page'     => 'Page',
    'pagination.previous' => '&laquo; Previous',

    'placeholder.action' => 'Action',
    'placeholder.active' => 'Active',
    'placeholder.email'  => 'EMail',
    'placeholder.id'     => 'ID',
    'placeholder.label'  => 'Label',
    'placeholder.labels' => 'Labels',
    'placeholder.name'   => 'Name',

    'required-hint'   => 'Fields marked (<span class="required-marker">:marker</span>) are required',
    'required-marker' => '*',

    'select-option.all'                  => ' -- All -- ',
    'select-option.empty'                => ' - ',
    'select-option.none'                 => ' -- None -- ',
    'select-option.no-options-available' => 'No options available',
    'select-option.please-select'        => ' -- Please select -- ',
    'select-option.select-or-search'     => ' -- Select or search -- ',

    'sorting.direction.ascending'  => 'ascending',
    'sorting.direction.descending' => 'descending',
    'sorting.heading' => 'Sorting',
    'sorting.no-sorting' => ' -- None -- ',

    'status.active'   => 'Active',
    'status.expired'  => 'Expired',
    'status.inactive' => 'Inactive',
    'status.invalid'  => 'Invalid',
    'status.loading'  => 'Loading...',
    'status.not-set'  => 'Not set',
    'status.valid'    => 'Valid',
    'status.verified' => 'Verified',

    'user-menu.logout'  => 'Logout',
    'user-menu.profile' => 'Profile',

    'weekdays.'.Weekday::Sunday->name    => 'Sunday',
    'weekdays.'.Weekday::Monday->name    => 'Monday',
    'weekdays.'.Weekday::Tuesday->name   => 'Tuesday',
    'weekdays.'.Weekday::Wednesday->name => 'Wednesday',
    'weekdays.'.Weekday::Thursday->name  => 'Thursday',
    'weekdays.'.Weekday::Friday->name    => 'Friday',
    'weekdays.'.Weekday::Saturday->name  => 'Saturday',

    'weekdays.'.Weekday::Sunday->value    => 'Sunday',
    'weekdays.'.Weekday::Monday->value    => 'Monday',
    'weekdays.'.Weekday::Tuesday->value   => 'Tuesday',
    'weekdays.'.Weekday::Wednesday->value => 'Wednesday',
    'weekdays.'.Weekday::Thursday->value  => 'Thursday',
    'weekdays.'.Weekday::Friday->value    => 'Friday',
    'weekdays.'.Weekday::Saturday->value  => 'Saturday',

];
