{{--
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Views
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 --}}

    <div x-data="{!! $grid->getName() !!}" wire:init="init">

@php

    $buttonAlign = '';
    $actions = $grid->getActions();
    $data = $grid->getData();
    $sorting = $grid->getSorting();

    // $data = [];
    // dump($data);

@endphp

        <div class="my-4">
            <h2 class="text-4xl font-extrabold dark:text-white">
                @lang($grid->lc('heading'))
            </h2>

@if($grid->lc('description') !== 'description')

            <p class="my-4 text-lg text-gray-500">
                @lang($grid->lc('description'))
            </p>

@endif

        </div>
        <div class="relative bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
            <div class="p-4">

@if(isset($search) || isset($additional) || isset($button))

                {{-- Erste Zeile: Suchfeld(er) + Action-Button --}}
                <div class="flex flex-col items-center justify-between space-y-3 md:flex-row md:space-y-0 md:space-x-4">

    @if(isset($search))
        @php
            $buttonAlign = 'margin-top:1.5rem;';
        @endphp

                    <div class="w-full md:w-1/2">
                        {{-- Optionaler Slot für das Suchfeld --}}
                        {{ $search ?? '' }}
                    </div>

    @else
        @if(!isset($additional))

                    <div class="w-full md:w-1/2"></div>

        @endif
    @endif

    @if(isset($additional))
        @php
            $buttonAlign = 'margin-top:1.5rem;';
        @endphp

                    <div class="flex flex-col items-stretch justify-end flex-shrink-0 w-full space-y-2 md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">
                        {{-- Optionaler Slot für zusätzliche Suchfelder --}}
                        {{ $additional ?? '' }}
                    </div>

    @endif

    @if(isset($button))

                    <div style="{{ $buttonAlign }}" class="flex flex-col items-stretch justify-end flex-shrink-0 w-full space-y-2 md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">

                        {{-- Optionaler Slot für Button --}}
                        {{ $button ?? '' }}
                    </div>

    @endif

                </div>

@endif

@if(isset($filters))
    @if(isset($search) || isset($additional) || isset($button))

                {{-- Zweite Zeile: Filter --}}
                <hr class="my-4">

    @endif

                <div class="flex flex-col items-stretch flex-shrink-0 w-full md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">
                    {{ $filters }}


    @if(!empty($sorting['columns']))

                    <div class="flex flex-col absolute right-4">
                        <livewire:globals::global.sort-select
                            :columns="$sorting['columns']"
                            :selected-column="$sorting['column']"
                            :direction="$sorting['direction']"
                        />
                    </div>

    @endif

                </div>

@endif

            </div>

@if(!empty($data))
                {{-- Grid --}}
                <div class="overflow-x-auto">
                    <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">

    @if($grid->useCaptions() === true)

                        <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                            <tr>

        @foreach($grid->getCaptions() as $caption)

                                <th scope="col" class="px-4 py-3">
                                    {{ $caption }}
                                </th>

        @endforeach
        @if(!empty($actions))

                                <th scope="col" class="px-4 py-3">
                                    @lang('globals::global.caption.action')
                                </th>

        @endif

                            </tr>
                        </thead>

    @endif

                        <tbody>

    @foreach($data as $item)

                            <tr id="item-{{ $item->id }}" class="border-t dark:border-gray-700">

        @foreach($grid->getVisibleColumns() as $column)
            @if($column === $grid->getIdentifyingColumn())

                                <th scope="row" class="px-4 py-3 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                    {!! $grid->getDisplayValue($item, $column) !!}
                                </th>

            @else

                                <td class="border-gray-300 px-4 py-2">
                                    {!! $grid->getDisplayValue($item, $column) !!}
                                </td>

            @endif
        @endforeach
        @if(!empty($actions))

                                <td class="flex py-3">

            @foreach($actions as $action)

                                    <button data-tippy-content="{{ __('globals::global.action.edit') }}" type="button" x-on:click="$dispatch('show-{!! $action !!}-appointment-modal', { appointment: @js($item) })"
                                        class="inline-flex items-center p-0.5 text-sm font-medium text-center text-gray-500 hover:text-gray-800 rounded-lg focus:outline-none dark:text-gray-400 dark:hover:text-gray-100">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                            <path d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </button>

            @endforeach

                                </td>

        @endif

                            </tr>

    @endforeach

                        </tbody>
                    </table>
                </div>
                {{-- /Grid --}}
            </div>

    @if($data instanceof \Illuminate\Pagination\LengthAwarePaginator && $data->lastPage() > 1)

                <div class="p-4">
                    {{ $data->links() }}
                </div>

    @endif

        </div>

@else {{-- empty($data) --}}

        <div class="max-w-screen-xl px-4 py-8 mx-auto lg:py-16 lg:px-6">
            <div class="max-w-screen-sm mx-auto text-center">
                <div class="flex justify-center">
                    <svg aria-hidden="true" class="w-24 h-24 mb-4 font-extrabold tracking-tight lg:text-9xl text-primary-600 dark:text-primary-500" fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd" />
                    </svg>
                </div>
                <p class="mb-4 text-3xl font-bold tracking-tight text-gray-900 md:text-4xl dark:text-white">
                    @lang($grid->lc('no-data'))
                </p>

    {{--
    @if($grid->hasData())

                    <p class="mb-4 text-lg font-light text-gray-500 dark:text-gray-400">
                        @lang($grid->lc('search-result.not-found'))
                    </p>

    @else

                    <p class="mb-4 text-lg font-light text-gray-500 dark:text-gray-400">
                        @lang($grid->lc('info.not-found-description'))
                    </p>

    @endif
    --}}

            </div>
        </div>

@endif

@if(isset($script))

        <script>
            {{ $script }}
        </script>

@endif

    </div>
