@props(['disabled' => false, 'label' => null, 'active' => true, 'mandatory' => false, 'readonly' => false])

<div x-show="{{ $active ? 'true' : 'false' }}">

    {{-- @if (!empty($label))
        <div class="flex items-center">

        </div>
    @endif --}}
    <label class="inline-flex items-center cursor-pointer">
        <input {{ $disabled || $readonly ? 'disabled' : '' }} type="checkbox" value="" class="sr-only peer" wire:model="{{$attributes['wire:model']}}">
        <div {!! $attributes->merge([
            'class' =>
                "relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600 dark:peer-checked:bg-blue-600",
        ]) !!}></div>
        <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
            <x-label :for="$attributes['id']" :value="$label" />
            @if ($mandatory)
                <span class="text-red-500">*</span>
            @endif
        </span>
    </label>

    <x-input-error :for="$attributes['wire:model']" />
</div>
