<!DOCTYPE html>
<html lang="de">
  <head>
    <meta charset="UTF-8">
    <title>@lang('globals::demo.page.title')</title>
    <style>

        body {
            background-color: black;
            color           : gray;
            font-family     : monospace;
        }

        #terminal {
            color           : lime;
            font-size       : 1.2em;
            height          : 100%;
            margin-top      : 20px;
            overflow-y      : scroll;
            padding         : 1rem;
            white-space     : pre;
        }

      </style>
  </head>
  <body>

    <h1>@lang('globals::demo.page.heading')</h1>

    <div id="terminal">
        @lang('globals::demo.info.starting')<br />
    </div>

    <script>
        const terminal = document.getElementById('terminal');
        const eventSource = new EventSource('/demo-reset-stream');

        eventSource.onmessage = function(event) {
            terminal.innerHTML += event.data + "<br />";
            // terminal.scrollTop = terminal.scrollHeight;

            window.scrollTo(0, document.body.scrollHeight);
        };

        eventSource.onerror = function(event) {
            terminal.innerHTML += '<br />'
                + '<strong>{{ __('globals::demo.info.done') }}</strong>'
                + '<br />'
                + '<br /><a href="/" style="color:white; font-size:1.2em; text-decoration:none;">&laquo; {{ __('globals::global.action.back') }}</a>'
                + '<br />';

            eventSource.close();

            window.scrollTo(0, document.body.scrollHeight);
        };
    </script>

  </body>
</html>
