{{--
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Templates
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
--}}

                <div class="py-6 px-4 space-y-6 sm:p-6 border-b border-gray-200">
                  {!! __('globals::core-tenants.info.locales') !!}
                </div>


                <div class="flex items-center justify-center bg-white px-4 Xpy-2 Xw-full">
                  <div class="m-4">
                    <ul drag-root>

@foreach ($this->availableLocales as $availableLocale)

                      <li drag-item draggable="true">

    @if (isset($locales[$availableLocale]))

                        <x-globals::form-elements.toggle group="locales" label="{{ __('globals::global.languages.'.$availableLocale) }}" name="{!! $availableLocale !!}" :readOnly="$readOnly" />

    @else

                        <x-globals::form-elements.toggle group="newLocales" label="{{ __('globals::global.languages.'.$availableLocale) }}" name="{!! $availableLocale !!}" :readOnly="$readOnly" />

    @endif

                      </li>

@endforeach

                    </ul>
                  </div>
                </div>


                <script>

                    let root = document.querySelector('[drag-root]');

                    root.querySelectorAll('[drag-item]').forEach (el => {
                        el.addEventListener('dragstart', e => {
                            e.target.setAttribute('dragging', true);
                        });

                        el.addEventListener('drop', e => {
                            e.target.classList.remove('bg-yellow-100');
                            //  Get the dragging element
                            let draggingEl = root.querySelector('[dragging]');
                            //  insert before the drop target
                            e.target.before(draggingEl);
                        });

                        el.addEventListener('dragenter', e => {
                            e.target.classList.add('bg-yellow-100');

                            e.preventDefault();
                        });

                        el.addEventListener('dragover', e => {
                            //console.log(e.target);

                            e.preventDefault();
                        });

                        el.addEventListener('dragleave', e => {
                            e.target.classList.remove('bg-yellow-100');
                        });

                        el.addEventListener('dragend', e => {
                            e.target.removeAttribute('dragging');
                        });

                    });

               </script>
