<?php
/**
 * Delete Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Actions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Actions\RoleUser;


use BplanBase\Globals\Foundation\Actions\BaseAction;
use BplanBase\Globals\Models\RoleUser;
use BplanBase\Globals\Models\User;
use Illuminate\Database\Eloquent\Model;


/**
 * Delete Action Class
 *
 * @version     1.0.0 / 2025-04-15
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DeleteUserRoles extends BaseAction
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = RoleUser::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       int|string|User $user
     *
     * @return      int
     *
     * @version     1.0.0 / 2025-04-15
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(int|string|Model $user): int
    {
        if ($user instanceof User) {
            $userId = $user->id;
        } else {
            $userId = $user;
        }
        return RoleUser::where('user_id', '=', $userId)
            ->delete();

    } // execute()


} // class DeleteUserRoles extends BaseAction {}
