<?php
/**
 * Create Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-16 00:00:00
 * @package     bplan-base/globals
 * @subpackage  Actions
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Actions\TenantRecord;


use BplanBase\Globals\Foundation\Actions\BaseAction;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Models\TenantRecord;
use Illuminate\Database\Eloquent\Model;


/**
 * Create Action Class
 *
 * @version     1.4.0 / 2025-06-03
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Create extends BaseAction
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = TenantRecord::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Tenant $Tenant
     *
     * @return      TenantRecord
     *
     * @version     4.1.0 / 2025-06-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(Model $Tenant): Model
    {
        /*
        **  Korrespondierenden TenantRecord-Objekt erstellen. */
        if ($Tenant instanceof DerivedTenant) {
            $Model = new DerivedTenantRecord();
        } else {
            $Model = new TenantRecord();
        }
        /*
        **  ID, UUID und der Name für "company" werden vom Tenant übernommen.
        **  "company" ist in der Folge aber unabhängig vom Identifier des Tenants
        **  und kann beliebig geändert werden. */
        $Model->id = $Tenant->id;
        $Model->uuid = $Tenant->uuid;
        $Model->company = $Tenant->identifier;

        $Model->save();

        return $Model;

    } // execute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Create extends BaseAction {}
