<?php
/**
 * Update Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-18 13:14:15
 * @package     bplan-base/globals
 * @subpackage  Actions
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Actions\UserRecord;


use BplanBase\Globals\Actions\User\UpdateEmail as UpdateUserEmail;
use BplanBase\Globals\Foundation\Actions\BaseAction;
use BplanBase\Globals\Models\UserRecord;
use Illuminate\Database\Eloquent\Model;


/**
 * Update Action Class
 *
 * @version     1.4.0 / 2025-09-03
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Update extends BaseAction
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = UserRecord::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       int|string|UserRecord $userRecord
     *
     * @param       array $attributes
     *
     * @return      UserRecord
     *
     * @version     3.2.0 / 2025-09-03
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(int|string|Model $userRecord, array $attributes): Model
    {
        $Model = $this->_resolveModel($userRecord);

        $originalEmail = $Model->email;

        $Model->fill($attributes);

        $Model->save();

        if (isset($attributes['email']) && $attributes['email'] !== $originalEmail) {
            $Action = new UpdateUserEmail();

            $Action->execute($Model->id, $attributes['email']);
        }
        return $Model;

    } // execute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Update extends BaseAction {}
