<?php
/**
 * Base Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Foundation\Http\Controllers;


use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Request;


/**
 * Base Controller Class
 *
 * @version     1.1.0 / 2025-06-09
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
abstract class CoreController extends BaseController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     Collection $_Collection
     */
    protected Collection|null $_Collection = null;


    /**
     * @var     string $_formClass
     */
    protected string $_formClass;


    /**
     * @var     string $_gridClass
     */
    protected string $_gridClass;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass;


    /**
     * @var     Request $_Request
     */
    protected Request $_Request;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName;


    /**
     * @var     $_Service
     */
    protected $_Service;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       BaseWebRepository $Repository
     *
     * @param       $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, $Service)
    {
        $this->_Request = $Request;
        $this->_Service = $Service;

    } // __construct()


    /**
     * Show the form for creating a new resource
     *
     * @return      \Illuminate\Http\Response
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create()
    {
        return view('globals::livewire.core.global.form-container', [
            'componentClass' => $this->_formClass,
            'MainObject' => null,
            'modelClass' => $this->_modelClass,
            'resourceName' => $this->_resourceName,
            'serviceClass' => $this->_Service::class,
        ]);
    } // create()


    /**
     * Remove the specified resource from storage
     *
     * @param       string $id
     *
     * @return      \Illuminate\Http\Response
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function destroy(string $id)
    {
        $this->_Service->delete($id);

        return $this->index();

    } // destroy()


    /**
     * Show the form for editing the specified resource
     *
     * @param       string $id
     *
     * @return      \Illuminate\Http\Response
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function edit(string $id)
    {
        return view('globals::livewire.core.global.form-container', [
            'componentClass' => $this->_formClass,
            'MainObject' => $this->_repositoryClass::getById($id),
            'modelClass' => $this->_modelClass,
            'resourceName' => $this->_resourceName,
            'serviceClass' => $this->_Service::class,
        ]);
    } // edit()


    /**
     * Show the grid for viewing all specified resources
     *
     * @return      \Illuminate\Http\Response
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function index()
    {
        if ($this->_Collection === null) {
            $this->_Collection = $this->_repositoryClass::getAll();
        }
        return view('globals::livewire.core.global.grid-container', [
            'Collection' => $this->_Collection,
            'componentClass' => $this->_gridClass,
            'modelClass' => $this->_modelClass,
            'resourceName' => $this->_resourceName,
            'serviceClass' => $this->_Service::class,
        ]);
    } // index()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // abstract class CoreController extends BaseController{}
