<?php
/**
 * Base Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Foundation\Repositories;


use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use InvalidArgumentException;


/**
 * Base Repository Class
 *
 * @version     3.0.0 / 2025-06-17
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BaseRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       int|string|Model $model
     *
     * @return      int|string
     *
     * @version     1.0.0 / 2025-06-17
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function _resolveId(int|string|Model $model): int|string
    {
        if ($model instanceof Model) {
            return $model->id;
        }
        return $model;

    } // _resolveId()


    /**
     *
     * @param       int|string|Model $model
     *
     * @return      Model
     *
     * @version     1.0.0 / 2025-06-17
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function _resolveModel(int|string|Model $model): Model
    {
        if ($model instanceof Model) {
            return $model;
        }
        return static::getById($model);

    } // _resolveModel()


    /**
     *
     * @throws      InvalidArgumentException
     *
     * @param       Builder|null $Query
     *
     * @return      Builder
     *
     * @version     1.1.0 / 2025-06-17
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function _resolveQuery(Builder|null $Query = null): Builder
    {
        $Query ??= static::$_modelClass::query();

        $QueryModel = $Query->getModel();

        if (($QueryModel instanceof static::$_modelClass) === false) {
            throw new InvalidArgumentException('Expected builder for ['.static::$_modelClass.'], got ['.get_class($QueryModel).'].');
        }
        return $Query;

    } // _resolveQuery()


} // class BaseRepository {}
