<?php #CodeGenerator V3 Δ 43453ec397805e2d1056887841b5d641 Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * Form Request Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-11-19 18:36:25
 * @package     bplan-base/globals
 * @subpackage  FormRequests
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Requests\Location;


use BplanBase\Globals\Traits\FormRequestKeyPrefix;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;


/**
 * Form Request Class
 *
 * @version     1.0.0 / 2025-11-19
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UpdateRequest extends FormRequest
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use FormRequestKeyPrefix;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         null|string $_prefix
     */
    protected null|string $_prefix;


    /**
     * @var         int|string|null $_recordId
     */
    protected int|string|null $_recordId;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Get the ID
     *
     * @return      int|string|null
     *
     * @version     1.0.0 / 2025-11-19
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _resolveRecordId(): int|string|null
    {
        if ($this->_recordId !== null) {
            return $this->_recordId;
        }
        /*
            Implement the logic to get the ID out of the request.
        return $this->route('user') ?? $this->input('id');
        */
        return null;

    } // _resolveRecordId()


    /**
     * Determine if the user is authorized to make this request
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-11-19
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function authorize(): bool
    {
        return true;

    } // authorize()


    /**
     * Get the validation rules that apply to the request
     *
     * @return      array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     *
     * @version     1.0.0 / 2025-11-19
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function rules(): array
    {
        $recordId = $this->_resolveRecordId();

        $rules = [
            'active'           => ['sometimes', 'required', 'boolean'],
            'address_addition' => ['nullable', 'string', 'max:255'],
            'city'             => ['nullable', 'string', 'max:50'],
            'coordinates'      => ['nullable', 'string'],
            'email'            => ['nullable', 'email', 'max:255', Rule::unique('locations', 'email')->ignore($this->_resolveRecordId())],
            'house_number'     => ['nullable', 'string', 'max:5'],
            'labels'           => [],
            'location_type_id' => ['nullable', 'integer'],
            'master_id'        => ['nullable', 'integer'],
            'phone_number'     => ['nullable', 'string', 'max:30'],
            'street'           => ['nullable', 'string', 'max:50'],
            'top_level'        => ['sometimes', 'required', 'boolean'],
            'zip_code'         => ['nullable', 'string', 'max:10'],

        ];
        if ($this->_prefix === null) {
            return $rules;
        }
        return $this->_prependValidationRuleKeys($rules, $this->_prefix);

    } // rules()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Set the ID and get the validation rules that apply to the request
     *
     * @param       int|string $recordId
     *
     * @param       null|string $prefix
     *
     * @return      array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     *
     * @version     1.0.0 / 2025-11-19
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getRules(int|string $recordId, null|string $prefix = null): array
    {
        $Instance = new static();

        $Instance->_recordId = $recordId;
        $Instance->_prefix = $prefix;

        return $Instance->rules();

    } // getRules()


} // class UpdateRequest extends FormRequest {}
