<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Core\TenantRecord;


use BplanBase\Globals\Livewire\Core\Global\BaseForm;
use BplanBase\Globals\Services\TenantService;
use BplanBase\Globals\Repositories\CountryRepository;
use BplanBase\Globals\Repositories\TenantRepository;
use Exception;


/**
 * @todo        Noch nicht ausprogrammiert.
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Form extends BaseForm
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $countries
     */
    public $countries;


    /**
     *  @var    array $main
     */
    public $main = [
        'city'        => '',
        'company'     => '',
        'house_number' => '',
        'street'      => '',
        'zip_code'     => '',
    ];


    /**
     * @var     array $tenant
     */
    public $tenant = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initCountries(): void
    {
        $this->countries = CountryRepository::getLocalizedList();

    } // _initCountries()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initTenant(): void
    {
        $Tenant = TenantRepository::getById($this->MainObject->id);

        $this->tenant = [$this->MainObject->id => $Tenant->identifier];

    } // _initTenant()


    /**
     * Überschreibt die gleichnamige Methode der Base-Klasse
     *
     * TenantRecords können nur gelöscht werden indem der zugehörige Tenant gelöscht wird. Deshalb
     * muss die Löschung hier mit der TenantService-Klasse durchgeführt werden.
     *
     * @todo        Prüfen warum hier nicht die Methode der Elternklasse verwendet wird.
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete()
    {
        $this->hideModal();

        try {
            $Service = new TenantService();

            $Service->delete($this->MainObject->id);

            return redirect()->route($this->getRedirectRoute('Delete'), $this->getRedirectParameters('Delete'));

        } catch (Exception $Exception) {
            $this->_showNotification($Exception->getMessage());
        }
    } // delete()


    /**
     * Überschreibt die gleichnamige Methode der Base-Klasse
     *
     * Für das Formular müssen noch die Auswahlwerte für die Länderauswahl initialisiert werden.
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount(): void
    {
        parent::mount();

        $this->_initCountries();
        $this->_initTenant();

    } // mount()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Form extends BaseForm {}
