<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-11 08:58:13
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Individual\Modals;

use BplanBase\Globals\Services\IndividualService;
use BplanBase\Globals\Livewire\Forms\IndividualForm;
use BplanBase\Globals\Models\EntityType;
use Illuminate\Database\Eloquent\Collection;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-06-11
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Create extends Component
{


    /* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */

    /**
     * @var         ?Collection $fieldDefinition
     */
    public ?Collection $fieldDefinition;

    /**
     * @var         IndividualForm $form
     */
    public IndividualForm $form;

    /**
     * @var         EntityType $entityType
     */
    public EntityType $entityType;

    /**
     * @var         IndividualService $Service
     */
    protected IndividualService $_Service;



    /* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */

    /**
     *
     * @param       IndividualService $Service
     *
     * @version     1.0.0 / 2025-06-11
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(IndividualService $Service)
    {
        $this->_Service = $Service;
    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-06-11
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        $this->_setFieldDefinition();
    } // mount()

    /**
     *
     * @version     1.0.0 / 2025-06-11
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('globals::livewire.individuals.modals.create');
    } // render()

    /**
     *
     * @version     1.0.0 / 2025-06-11
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create()
    {
        $this->form->create();
        $this->dispatch('individual-created');

    } // create()

    /**
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _setFieldDefinition()
    {
        $this->fieldDefinition = new Collection();

        if (isset($this->entityType)) {
            $this->fieldDefinition = $this->entityType->fields()->get()->keyBy('db_field_name');
        }
    } // _setFieldDefinition()

    /**
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-06-11
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function rules(): array
    {
        $rules = [];

        return $rules;
    } // rules()


    /* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */
} // class Add extends Component {}
