<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Location\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanBase\Globals\Models\Location;
use BplanBase\Globals\Models\LocationType;
use BplanBase\Globals\Repositories\LocationRepository;
use BplanBase\Globals\Repositories\LocationTypeRepository;
use BplanBase\Globals\Services\LocationService;
use Illuminate\Database\Eloquent\Collection;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Attributes\Validate;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Edit extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var boolean
     */
    // #[Validate('required')]
    public bool $active = true;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $city = null;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $email = null;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $housenumber = null;


    /**
     *
     * @var array|null
     */
    #[Validate('required')]
    public ?array $labelsJson;


    /**
     *
     * @var Location|null
     */
    public ?Location $location;


    /**
     *
     * @var Collection|null
     */
    public ?Collection $locations;


    /**
     *
     * @var LocationService
     */
    protected LocationService $locationService;


    /**
     *
     * @var Collection|null
     */
    public ?Collection $locationTypes;


    /**
     *
     * @var string|null
     */
    #[Validate('nullable|required|numeric|exists:location_types,id')]
    public ?string $location_type_id = null;


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


    /**
     *
     * @var Location|null
     */
    public ?Location $parent;


    /**
     *
     * @var string|null
     */
    #[Validate('nullable|required|numeric|exists:locations,id')]
    public ?string $parent_location_id = null;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $phonenumber = null;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $postcode = null;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $street = null;


    /**
     *
     * @var Collection|null
     */
    public ?Collection $sublocations;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getAllSubloactionIds(Location $location): array
    {
        $sublocationIds = [$location->id];

        foreach ($location->locations as $key => $sublocation) {
            foreach (array_values($this->_getAllSubloactionIds($sublocation)) as $key => $value) {
                $sublocationIds[] = $value;
            }
        }
        return $sublocationIds;

    } // _getAllSubloactionIds()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getForbiddenSublocationIds(): array
    {
        $forbiddenIds = $this->_getAllSubloactionIds($this->location);

        return $forbiddenIds;

    } // _getForbiddenSublocationIds()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService, LocationService $locationService)
    {
        $this->logService = $logService;
        $this->locationService = $locationService;

        $this->locations = LocationRepository::getAll();
        $this->sublocations = new Collection();
        $this->locationTypes = LocationTypeRepository::getAll();

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function editLocation()
    {
        $this->validate();

        try {
            $this->locationService->update($this->location->id, [
                'active' =>  $this->active,
                'city' =>  $this->city,
                'email' =>  $this->email,
                'house_number' =>  $this->housenumber,
                'labels' =>  $this->labelsJson,
                'location_type_id' => $this->location_type_id != 0 ? $this->location_type_id : null ,
                // 'master_id' =>  $this->parent_location_id != 0 ? $this->parent_location_id : null ,
                'phone_number' =>  $this->phonenumber,
                'street' =>  $this->street,
                'zip_code' =>  $this->postcode,
            ]);

            $this->logService->log(LogLevel::Info, "Location {$this->labelsJson['en']} edited by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('location-edited');

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Locations/Modals/EditLocation error editLoaction: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing location. Check the logs for more information.');
        }
    } // editLocation()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('show-edit-location-modal')]
    public function initLocation(Location $location)
    {
        $this->location = $location;
        $this->sublocations = $location->locations ?? new Collection();
        $this->parent = $location->master;

        $this->active = $location->active;
        $this->city = $location->city;
        $this->email = $location->email;
        $this->housenumber = $location->house_number;
        $this->labelsJson = (array)$location->labels;
        $this->location_type_id = $location->location_type_id;
        $this->parent_location_id = $location->master_id;
        $this->phonenumber = $location->phone_number;
        $this->postcode = $location->zip_code;
        $this->street = $location->street;

        $this->dispatch('init-tippyjs');

    } // initLocation()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('multi-language-json-created')]
    public function onMultiLanguageJsonCreated(?array $json, string $target)
    {
        if ($target == 'edit') {
            $this->labelsJson = $json;
        }
    } // onMultiLanguageJsonCreated()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('globals::livewire.locations.modals.edit');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->active = true;
        $this->city = null;
        $this->email = null;
        $this->housenumber = null;
        $this->labelsJson = null;
        $this->location = null;
        $this->phonenumber = null;
        $this->postcode = null;
        $this->street = null;

    } // resetModal()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Edit extends Component {}
