<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-05 20:20:17
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\User\Modals;


use App\Rules\ArrayAtLeastOneRequired;
use BplanBase\Globals\Models\RoleUser;
use BplanBase\Globals\Models\User;
use BplanBase\Globals\Repositories\Core\RoleRepository;
use BplanBase\Globals\Services\LogService;
use BplanBase\Globals\Services\RoleUserService;
use BplanBase\Globals\Services\UserService;
use Illuminate\Database\Eloquent\Collection;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.1.0 / 2025-09-01
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Edit extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var
     */
    public string $name;


    /**
     * @var
     */
    public string $email;


    /**
     * @var
     */
    protected LogService $logService;


    /**
     * @var
     */
    public ?Collection $roles;


    /**
     * @var
     */
    public array $selectedRoles;


    /**
     * @var
     */
    public User $user;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var
     */
    private static $_logPrefix = 'Users/Modals/Edit';


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       LogService $logService
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService)
    {
        $this->logService = $logService;

    } // boot()


    /**
     *
     * @return
     *
     * @version     1.1.0 / 2025-09-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleteUser()
    {
        try {
            $UserService = new UserService();

            $UserService->delete($this->user);

            $this->dispatch('user-deleted');

        } catch (\Throwable $th) {
            \AppLog::error($th, self::$_logPrefix, exceptionMessageIntro: 'Error deleting user');

            $this->dangerBanner('Error when deleting user. Check the logs for more information.');
        }
    } // deleteUser()


    /**
     *
     * @return void
     *
     * @version     1.1.0 / 2025-09-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function editUser()
    {
        $this->validate([
            'name' => 'required',
            'email' => 'required|email:rfc,dns|unique:users,email,'.$this->user->id,
            'selectedRoles' => ['required', new ArrayAtLeastOneRequired()],
        ]);

        try {
            $this->user->update([
                'name' => $this->name,
                'email' => $this->email,
            ]);

            $roleUserService = new RoleUserService();

            foreach ($this->selectedRoles as $roleId => $isRoleSelected) {
                if ($isRoleSelected) {
                    $roleUserService->create([
                        'user_id' => $this->user->id,
                        'role_id' => $roleId
                    ]);

                } else {
                    $roleUser = RoleUser::where('user_id', $this->user->id)->where('role_id', $roleId)->first();
                    $roleUserService->delete($roleUser);
                }
            }
            \AppLog::info('User '.$this->name.' ('.$this->email.') edited by '.auth()->user()->name.' ('.auth()->user()->email.')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('user-edited');

        } catch (\Throwable $th) {
            \AppLog::error($th, self::$_logPrefix);

            $this->dangerBanner('Error when editing user. Check the logs for more information.');
        }
    } // editUser()


    /**
     *
     * @param User $user
     * @return void
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('show-edit-user-modal')]
    public function initUser(User $user)
    {
        $this->user = $user;

        $this->name = $user->name;
        $this->email = $user->email;
        $this->selectedRoles = [];

        foreach ($user->roles as $key => $role) {
            $this->selectedRoles[$role->id] = true;
        }
        $this->dispatch('init-tippyjs');

    } // initUser()


    /**
     *
     * @version     1.1.0 / 2025-09-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        $this->roles = RoleRepository::getAll()->keyBy('id');

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('globals::livewire.users.modals.edit');

    } // render()


    /**
     *
     * @return void
     *
     * @version     1.1.0 / 2025-09-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetPassword()
    {
        try {
            $UserService = new UserService();

            $UserService->resetPassword($this->user);

            $this->dispatch('user-password-reset');

        } catch (\Throwable $th) {
            \AppLog::error($th, self::$_logPrefix, exceptionMessageIntro: 'Error reset password');

            $this->dangerBanner('Error when resetting password. Check the logs for more information.');
        }
    } // resetPassword()


    /**
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function rules(): array
    {
        $rules = [];

        return $rules;

    } // rules()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Edit extends Component {}
